tic
cd('/BIGDATA1/cqu_yyzhang_1/MATLAB/work/U_IG')
clear; clc;

k = str2num(getenv('k'))
class(k)
fprintf('k = %d\n', k)

global x
M1 = 5
it_max = 10
ep = 1e-5 % note here, ep = 1e-5
n = 1500 % note here, n = 1500

% alpha_1_beta_1 and X are contained in gof_data.mat
load('data/gof_data.mat')
alpha_1_beta_1_k = alpha_1_beta_1((1:5) + (k - 1) * 5, :)
X_k = X((1:5) + (k - 1) * 5, :);
size_alpha_1_beta_1_k = size(alpha_1_beta_1_k)
size_X_k = size(X_k)

alpha_2_beta_2_k = zeros(M1, 2);
for i = 1:M1
    fprintf('In this cycle, i = %d\n', i)

    % Note that x is the sample.
    x = X_k(i, 1:n);

    % The MLE is very sensitive to the initial guess. 
    % The moment estimator is usually a good initial guess.
    [p, Iter, Index, FunVal] = Newtons(alpha_1_beta_1_k(i, :)', it_max, ep);
    alpha_2_beta_2_k(i, :) = p'
end
alpha_2_beta_2_k
Time_k = toc
save_goodness_of_fit_MLE_5_20(k, alpha_2_beta_2_k, Time_k)


